(defun c:puller()
(setq d10 (getreal "\n Enter puller diameter:"))
(if (= d10 4)
(progn
(setq D 8)
(setq H 6)
(setq d1 3.0)
(setq d2 2.8)
(setq d3 2.3)
(setq h1 2.5)
(setq e 10.0)))
(if (= d10 5)
(progn
(setq D 9.0)
(setq H 6)
(setq d1 3.5)
(setq d2 3.3)
(setq d3 2.8)
(setq h1 3)
(setq e 10.0)))
(setq p (getpoint "\n Enter insertion point:"))
(setq l (getdist "\n Enter puller length:"))
(setq a (getreal "\n Enter puller angle:"))
(setq b (* (/ a 180) pi))
(setq p1 (polar p (+ b (* 0.5 pi)) (/ D 2)))
(setq p2 (polar p1 b H))
(setq p3 (polar p2 (+ b (* 1.5 pi)) D))
(setq p4 (polar p1 (+ b (* 1.5 pi)) D))
(setq p5 (polar p2 (+ b (* 1.5 pi)) (/ (- D d10) 2)))
(setq p6 (polar p3 (+ b (* 0.5 pi)) (/ (- D d10) 2)))
(setq p7 (polar p6 b (- (- l H) (* (/ (- d10 d1) 2)
(/ (cos (/ pi (/ e 180.0))) (sin (* pi (/ e 180.0))))))))
(setq p8 (polar p7 (+ b (* 0.5 pi)) d10))
(setq p20 (polar p b l))
(setq p21 (polar p20 b h1))
(setq p9 (polar p20 (+ b (* 0.5 pi)) (/ d1 2)))
(setq p10 (polar p20 (+ b (* 1.5 pi)) (/ d1 2)))
(command "line" p1 p2 p3 p4 "c")
(command "line" p6 p7 p8 p5 "")
(command "line" p8 p9 p10 p7 "")
(command "line" (polar p20 (+ b (* 0.5 pi)) (/ d3 2))
(polar p21 (+ b (* 0.5 pi)) (/ d2 2))
(polar p21 (+ b (* 1.5 pi)) (/ d2 2))
(polar p20 (+ b (* 1.5 pi)) (/ d3 2)) "")
)
